<?php
	$widget_id = $this->get_id();
	$slides = $this->get_settings('slides');
	
	if(!empty($slides))
	{
		$count_slides = count($slides);
		switch($count_slides)
		{
			case 1:
		   		$column_class = 'one_col';
		   	break;
		   	
			case 2:
		   		$column_class = 'two_cols';
		   	break;
		   	
		   	case 3:
		   		$column_class = 'three_cols';
		   	break;
		   	
		   	case 4:
		   	default:
		   		$column_class = 'four_cols';
		   	break;
		}
		
		//Get all settings
		$settings = $this->get_settings();
?>
<div class="tg_background_list_wrapper <?php echo esc_attr($column_class); ?>">
<?php
		$last_class = '';
		$count = 1;
		
		foreach ($slides as $slide) 
		{
			$last_class = '';
			if($count%$count_slides == 0)
			{
				$last_class = 'last';
			}
?>
		<div class="tg_background_list_column <?php echo esc_attr($last_class); ?>">
			<div class="tg_background_list_content">
				<div class="tg_background_list_title">
					<h3><?php echo esc_html($slide['slide_title']); ?></h3>
				</div>
				
				<div class="tg_background_list_link">
					<div class="tg_background_list_desc"><?php echo esc_html($slide['slide_description']); ?></div>
					<?php
						if(!empty($slide['slide_link']['url']))
						{
							$target = $slide['slide_link']['is_external'] ? 'target="_blank"' : '';
					?>
			        <a class="button ghost" href="<?php echo esc_url($slide['slide_link']['url']); ?>" <?php echo esc_attr($target); ?>><?php echo esc_html($slide['slide_link_title']); ?></a>
			        <?php
						}
					?>
				</div>
			</div>
		</div>
		<figure class="tg_background_img <?php if($count == 1) { ?>hover<?php } ?>">
			<div class="tg_background_list_overlay"></div>
			<img src="<?php echo esc_url($slide['slide_image']['url']); ?>" alt="" />
		</figure>
<?php
			$count++;
		}
?>
</div>
<?php
	}
?>