;(function() {
'use strict';

/*!
 * Name    : Elements Extension for Jarallax
 * Version : 1.0.0
 * Author  : nK http://nkdev.info
 * GitHub  : https://github.com/nk-o/jarallax
 */
(function () {
    if (typeof jarallax === 'undefined') {
        return;
    }

    // init events
    function addEventListener(el, eventName, handler) {
        el.addEventListener(eventName, handler);
    }

    var Jarallax = jarallax.constructor;

    // redefine default methods
    ['initImg', 'canInitParallax', 'init', 'destroy', 'clipContainer', 'coverImage', 'isVisible', 'onScroll', 'onResize'].forEach(function (key) {
        var def = Jarallax.prototype[key];
        Jarallax.prototype[key] = function () {
            var self = this;
            var args = arguments || [];

            if (key === 'initImg' && self.$item.getAttribute('data-jarallax-element') !== null) {
                self.options.type = 'element';
                self.pureOptions.speed = self.$item.getAttribute('data-jarallax-element') || self.pureOptions.speed;
            }
            if (self.options.type !== 'element') {
                return def.apply(self, args);
            }

            switch (key) {
                case 'init':
                    var speedArr = self.pureOptions.speed.split(' ');
                    self.options.speed = self.pureOptions.speed || 0;
                    self.options.speedY = speedArr[0] ? parseFloat(speedArr[0]) : 0;
                    self.options.speedX = speedArr[1] ? parseFloat(speedArr[1]) : 0;
                    self.onResize();
                    self.onScroll();
                    self.addToParallaxList();
                    break;
                case 'onResize':
                    var defTransform = self.css(self.$item, 'transform');
                    self.css(self.$item, { transform: '' });
                    var rect = self.$item.getBoundingClientRect();
                    self.itemData = {
                        width: rect.width,
                        height: rect.height,
                        y: rect.top + self.getWindowData().y,
                        x: rect.left
                    };
                    self.css(self.$item, { transform: defTransform });
                    break;
                case 'onScroll':
                    var wnd = self.getWindowData();
                    var centerPercent = (wnd.y + wnd.height / 2 - self.itemData.y) / (wnd.height / 2);
                    var moveY = centerPercent * self.options.speedY;
                    var moveX = centerPercent * self.options.speedX;
                    self.css(self.$item, { transform: 'translate3d(' + moveX + 'px,' + moveY + 'px,0)' });
                    break;
                case 'initImg':
                case 'isVisible':
                case 'clipContainer':
                case 'coverImage':
                    return true;
                default:
                    return def.apply(self, args);
            }
        };
    });

    // data-jarallax-element initialization
    addEventListener(window, 'DOMContentLoaded', function () {
        jarallax(document.querySelectorAll('[data-jarallax-element]'));
    });
})();
}());
