<?php
	$profile = LP_Global::profile();
	$user = $profile->get_user();
	$profile_email = $user->get_email();
	$obj_user = get_user_by('email', $profile_email);
?>
<div id="page_caption">
	<div class="page_title_wrapper">
		<div class="standard_wrapper">
			<div class="page_title_inner">
				<?php
					$tg_page_title_font_alignment = get_theme_mod('tg_page_title_font_alignment', 'left');
				?>
				<div class="page_title_content title_align_<?php echo esc_attr($tg_page_title_font_alignment); ?>">
					<div class="profile_avatar"><?php echo stripslashes($user->get_profile_picture()); ?></div>
					<div class="profile_name">
						<h1><?php echo esc_attr($user->get_display_name()); ?></h1>
					</div>
					<br class="clear"/>
					<div class="profile_description">
						<?php echo esc_html($user->get_description()); ?>
						<br class="clear"/>
						<div class="profile_course_count">
							<span class="ti-agenda"></span>
							<span class="profile_course_count_number">
								<?php 
									$profile_course_count = count_user_posts($obj_user->ID, 'lp_course');
									
									echo intval($profile_course_count).' '; 
									
									if($profile_course_count > 1)
									{
										echo esc_html_e('Course', 'coursector' );
									}
									else
									{
										echo esc_html_e('Courses', 'coursector' );	
									}
								?>
							</span>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Begin content -->
<div id="page_content_wrapper">
		<?php
			//Include course grid template file
			get_template_part("/templates/template-course-grid");	

			$wp_query = coursector_get_wp_query();
			if($wp_query->max_num_pages > 1)
			{
				if (function_exists("coursector_pagination")) 
				{
				    coursector_pagination($wp_query->max_num_pages, 4, 'course-posts-grid' );
				}
				else
				{
		?>
			    	<div class="pagination"><p><?php posts_nav_link(''); ?></p></div>
		<?php
			    }
		?>
				<div class="pagination_detail">
				    <?php esc_html_e('Page', 'coursector' ); ?> <?php echo esc_html($paged); ?> <?php esc_html_e('of', 'coursector' ); ?> <?php echo esc_html($wp_query->max_num_pages); ?>
				</div>
		<?php
			}
			
			wp_reset_query();	
		?>
	</div>