<?php
//Setup theme constant and default data
$theme_obj = wp_get_theme('coursector');

define("COURSECTOR_THEMENAME", $theme_obj['Name']);
if (!defined('COURSECTOR_THEMEDEMO'))
{
	define("COURSECTOR_THEMEDEMO", false);
}
define("COURSECTOR_SHORTNAME", "pp");
define("COURSECTOR_THEMEVERSION", $theme_obj['Version']);
define("COURSECTOR_THEMEDEMOURL", $theme_obj['ThemeURI']);
define("COURSECTOR_MEGAMENU", true);

if (!defined('COURSECTOR_THEMEDATEFORMAT'))
{
	define("COURSECTOR_THEMEDATEFORMAT", get_option('date_format'));
}

if (!defined('COURSECTOR_THEMETIMEFORMAT'))
{
	define("COURSECTOR_THEMETIMEFORMAT", get_option('time_format'));
}

define("ENVATOITEMID", 24553720);

//Get default WP uploads folder
$wp_upload_arr = wp_upload_dir();
define("COURSECTOR_THEMEUPLOAD", $wp_upload_arr['basedir']."/".strtolower(sanitize_title(COURSECTOR_THEMENAME))."/");
define("COURSECTOR_THEMEUPLOADURL", $wp_upload_arr['baseurl']."/".strtolower(sanitize_title(COURSECTOR_THEMENAME))."/");

if(!is_dir(COURSECTOR_THEMEUPLOAD))
{
	wp_mkdir_p(COURSECTOR_THEMEUPLOAD);
}

/**
*  Begin Global variables functions
*/

//Get default WordPress post variable
function coursector_get_wp_post() {
	global $post;
	return $post;
}

//Get default WordPress file system variable
function coursector_get_wp_filesystem() {
	require_once(ABSPATH . 'wp-admin/includes/file.php');
	WP_Filesystem();
	global $wp_filesystem;
	return $wp_filesystem;
}

//Get default WordPress wpdb variable
function coursector_get_wpdb() {
	global $wpdb;
	return $wpdb;
}

//Get default WordPress wp_query variable
function coursector_get_wp_query() {
	global $wp_query;
	return $wp_query;
}

//Get default WordPress customize variable
function coursector_get_wp_customize() {
	global $wp_customize;
	return $wp_customize;
}

//Get default WordPress current screen variable
function coursector_get_current_screen() {
	global $current_screen;
	return $current_screen;
}

//Get default WordPress paged variable
function coursector_get_paged() {
	global $paged;
	return $paged;
}

//Get default WordPress registered widgets variable
function coursector_get_registered_widget_controls() {
	global $wp_registered_widget_controls;
	return $wp_registered_widget_controls;
}

//Get default WordPress registered sidebars variable
function coursector_get_registered_sidebars() {
	global $wp_registered_sidebars;
	return $wp_registered_sidebars;
}

//Get default Woocommerce variable
function coursector_get_woocommerce() {
	global $woocommerce;
	return $woocommerce;
}

//Get all google font usages in customizer
function coursector_get_google_fonts() {
	$coursector_google_fonts = array('tg_body_font', 'tg_header_font', 'tg_menu_font', 'tg_sidemenu_font', 'tg_sidebar_title_font', 'tg_button_font');
	
	global $coursector_google_fonts;
	return $coursector_google_fonts;
}

//Get menu transparent variable
function coursector_get_page_menu_transparent() {
	global $coursector_page_menu_transparent;
	return $coursector_page_menu_transparent;
}

//Set menu transparent variable
function coursector_set_page_menu_transparent($new_value = '') {
	global $coursector_page_menu_transparent;
	$coursector_page_menu_transparent = $new_value;
}

//Get no header checker variable
function coursector_get_is_no_header() {
	global $coursector_is_no_header;
	return $coursector_is_no_header;
}

//Get deafult theme screen CSS class
function coursector_get_screen_class() {
	global $coursector_screen_class;
	return $coursector_screen_class;
}

//Set deafult theme screen CSS class
function coursector_set_screen_class($new_value = '') {
	global $coursector_screen_class;
	$coursector_screen_class = $new_value;
}

//Get theme homepage style
function coursector_get_homepage_style() {
	global $coursector_homepage_style;
	return $coursector_homepage_style;
}

//Set theme homepage style
function coursector_set_homepage_style($new_value = '') {
	global $coursector_homepage_style;
	$coursector_homepage_style = $new_value;
}

//Get page gallery ID
function coursector_get_page_gallery_id() {
	global $coursector_page_gallery_id;
	return $coursector_page_gallery_id;
}

//Get default theme options variable
function coursector_get_options() {
	global $coursector_options;
	return $coursector_options;
}

//Set default theme options variable
function coursector_set_options($new_value = '') {
	global $coursector_options;
	$coursector_options = $new_value;
}

//Get top bar setting
function coursector_get_topbar() {
	global $coursector_topbar;
	return $coursector_topbar;
}

//Set top bar setting
function coursector_set_topbar($new_value = '') {
	global $coursector_topbar;
	$coursector_topbar = $new_value;
}

//Get is hide title option
function coursector_get_hide_title() {
	global $coursector_hide_title;
	return $coursector_hide_title;
}

//Set is hide title option
function coursector_set_hide_title($new_value = '') {
	global $coursector_hide_title;
	$coursector_hide_title = $new_value;
}

//Get theme page content CSS class
function coursector_get_page_content_class() {
	global $coursector_page_content_class;
	return $coursector_page_content_class;
}

//Set theme page content CSS class
function coursector_set_page_content_class($new_value = '') {
	global $coursector_page_content_class;
	$coursector_page_content_class = $new_value;
}

//Get Kirki global variable
function coursector_get_kirki() {
	global $kirki;
	return $kirki;
}

//Get admin theme global variable
function coursector_get_wp_admin_css_colors() {
	global $_wp_admin_css_colors;
	return $_wp_admin_css_colors;
}

//Get theme plugins
function coursector_get_plugins() {
	global $coursector_tgm_plugins;
	return $coursector_tgm_plugins;
}

//Set theme plugins
function coursector_set_plugins($new_value = '') {
	global $coursector_tgm_plugins;
	$coursector_tgm_plugins = $new_value;
}

$is_verified_envato_purchase_code = false;

//Get verified purchase code data
$pp_verified_envato_coursector = get_option("pp_verified_envato_coursector");
if(!empty($pp_verified_envato_coursector))
{
	$is_verified_envato_purchase_code = true;
}

$is_imported_elementor_templates_coursector = false;
$pp_imported_elementor_templates_coursector = get_option("pp_imported_elementor_templates_coursector");
if(!empty($pp_imported_elementor_templates_coursector))
{
	$is_imported_elementor_templates_coursector = true;
}
?>